package ru.yandex.travel.hotels.common.partners.bronevik.model;

public enum GuestNotificationType {
    COMMENT("comment"),
    CHECKIN_POLICIES("checkinPolicies"),
    ANTI_COVID_PROGRAM("AntiCovidProgram"),
    AGENCY_INFORMATION("agencyInformation"),
    CHECKIN_RULES("checkinRules"),
    PRIVILEGED_HOTELS("privilegedHotels"),
    BUSINESS_TRAVELER_CHOICE_PROGRAM("businessTravelerChoiceProgram"),
    UNKNOWN(null);

    private String value;

    GuestNotificationType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static GuestNotificationType fromValue(String value) {
        for (var notificationType: GuestNotificationType.values()) {
            if (notificationType.value != null && notificationType.value.equals(value)) {
                return notificationType;
            }
        }

        return UNKNOWN;
    }
}
