package ru.yandex.travel.hotels.common.partners.bronevik.model;

public enum MealsDevelopment implements Meal {
    CONTINENTAL_BREAKFAST(2),
    BUFFET_BREAKFAST(34),
    LUNCH(66),
    DINNER(67),
    HALF_BOARD(21),
    FULL_BOARD(20),
    UNKNOWN(null);

    private Integer value;

    MealsDevelopment(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static MealsDevelopment getMeal(Integer value) {
        for (var meal: MealsDevelopment.values()){
            if (meal.value != null && meal.value.compareTo(value) == 0) {
                return meal;
            }
        }
        return UNKNOWN;
    }

    public boolean isLunch() {
        return this.value.compareTo(MealsDevelopment.LUNCH.value) == 0;
    }
    public boolean isBreakfast() {
        return this.value.compareTo(MealsDevelopment.BUFFET_BREAKFAST.value) == 0
                || this.value.compareTo(MealsDevelopment.CONTINENTAL_BREAKFAST.value) == 0;
    }
    public boolean isDinner() {
        return this.value.compareTo(MealsDevelopment.DINNER.value) == 0;
    }
    public boolean isHalfBoard() {
        return this.value.compareTo(MealsDevelopment.HALF_BOARD.value) == 0;
    }
    public boolean isFullBoard() {
        return this.value.compareTo(MealsDevelopment.FULL_BOARD.value) == 0;
    }
}
