package ru.yandex.travel.hotels.common.partners.bronevik.model;

// TODO: fill when we get production meals
public enum MealsProduction implements Meal {
    CONTINENTAL_BREAKFAST(2),
    BUFFET_BREAKFAST(34),
    LUNCH(66),
    DINNER(67),
    HALF_BOARD(21),
    FULL_BOARD(20),
    UNKNOWN(null);

    private Integer value;

    MealsProduction(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static MealsProduction getMeal(Integer value) {
        for (var meal: MealsProduction.values()){
            if (meal.value != null && meal.value.compareTo(value) == 0) {
                return meal;
            }
        }
        return UNKNOWN;
    }

    public boolean isLunch() {
        return this.value.compareTo(MealsProduction.LUNCH.value) == 0;
    }
    public boolean isBreakfast() {
        return this.value.compareTo(MealsProduction.BUFFET_BREAKFAST.value) == 0
                || this.value.compareTo(MealsProduction.CONTINENTAL_BREAKFAST.value) == 0;
    }
    public boolean isDinner() {
        return this.value.compareTo(MealsProduction.DINNER.value) == 0;
    }
    public boolean isHalfBoard() {
        return this.value.compareTo(MealsProduction.HALF_BOARD.value) == 0;
    }
    public boolean isFullBoard() {
        return this.value.compareTo(MealsProduction.FULL_BOARD.value) == 0;
    }

}
