package ru.yandex.travel.hotels.common.partners.bronevik.model;

public enum Operation {

    PING("ping"),
    GET_MEALS("get_meals"),
    SEARCH_HOTEL_OFFERS("search_hotel_offers"),
    GET_HOTEL_INFO("get_hotel_info"),
    GET_HOTEL_OFFER_PRICING("get_hotel_offer_pricing"),
    CREATE_ORDER("create_order"),
    CANCEL_ORDER("cancel_order"),
    GET_ORDER("get_order"),
    SEARCH_ORDERS("search_orders"),
    GET_AMENITIES("get_amenities"),
    UNKNOWN(null);

    private String value;

    Operation(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static Operation getOperation(String value) {
        for (var operation: Operation.values()){
            if (operation.value != null && operation.value.equals(value)) {
                return operation;
            }
        }
        return UNKNOWN;
    }

}
