package ru.yandex.travel.hotels.common.partners.bronevik.model;

import ru.yandex.travel.commons.enums.ValueBasedEnum;

public enum OrderStatus implements ValueBasedEnum<Integer> {
    NEW(1),
    PROCESSING(2),
    AWAITING_CONFIRMATION(3),
    CONFIRMED(4),
    NOT_CONFIRMED(5),
    AWAITING_CLIENT_CONFIRMATION(6),
    CANCELLATION_IS_REQUESTED(7),
    AWAITING_CANCELLATION(8),
    CANCELLED_WITHOUT_PENALTY(9),
    CANCELLED_WITH_PENALTY(10),
    UNKNOWN(null);

    private Integer value;

    OrderStatus(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static OrderStatus fromValue(Integer value) {
        for (var status: OrderStatus.values()) {
            if (status.value != null && status.value.equals(value)) {
                return status;
            }
        }

        return UNKNOWN;
    }
}
