package ru.yandex.travel.hotels.common.partners.bronevik.model;

public enum RateType {
    REFUNDABLE_RATE("RefundableRate"),
    NON_REFUNDABLE_RATE("NonrefundableRate"),
    NON_REFUNDABLE_SPECIAL_BRONEVIK_RATE("NonRefundableSpecialBronevikRate"),
    NON_REFUNDABLE_LONG_STAY_SPECIAL_BRONEVIK_RATE("NonRefundableSpecialBronevikRate"),
    LHP("LHP"),
    UNKNOWN(null);

    private String value;

    RateType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static RateType getRateTypeFromString(String value) {
        for (var rateType: RateType.values()){
            if (rateType.value != null && rateType.value.equals(value)) {
                return rateType;
            }
        }
        return UNKNOWN;
    }
}
