package ru.yandex.travel.hotels.common.partners.bronevik.model;

public enum TaxType {
    DEPOSIT("DEPOSIT"),
    RESORT_FEE("RESORT_FEE"),
    UNKNOWN(null);

    private String value;

    TaxType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static TaxType fromValue(String value) {
        for (var taxType: TaxType.values()) {
            if (taxType.value != null && taxType.value.equals(value)) {
                return taxType;
            }
        }

        return UNKNOWN;
    }
}
