package ru.yandex.travel.hotels.common.partners.bronevik.utils

import ru.yandex.travel.hotels.common.partners.bronevik.AvailableAmenities
import ru.yandex.travel.hotels.common.partners.bronevik.AvailableAmenity
import ru.yandex.travel.hotels.common.partners.bronevik.AvailableMeal
import ru.yandex.travel.hotels.common.partners.bronevik.AvailableMeals
import ru.yandex.travel.hotels.common.partners.bronevik.Bed
import ru.yandex.travel.hotels.common.partners.bronevik.BedSet
import ru.yandex.travel.hotels.common.partners.bronevik.BedSets
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikException
import ru.yandex.travel.hotels.common.partners.bronevik.CancelOrderResponse
import ru.yandex.travel.hotels.common.partners.bronevik.ClientPriceDetails
import ru.yandex.travel.hotels.common.partners.bronevik.CreateOrderFault
import ru.yandex.travel.hotels.common.partners.bronevik.CreateOrderResponse
import ru.yandex.travel.hotels.common.partners.bronevik.CurrencyPriceDetails
import ru.yandex.travel.hotels.common.partners.bronevik.DescriptionDetails
import ru.yandex.travel.hotels.common.partners.bronevik.DetailedPrice
import ru.yandex.travel.hotels.common.partners.bronevik.FaultDetail
import ru.yandex.travel.hotels.common.partners.bronevik.GetHotelOfferPricingFault
import ru.yandex.travel.hotels.common.partners.bronevik.GetHotelOfferPricingResponse
import ru.yandex.travel.hotels.common.partners.bronevik.GetOrderResponse
import ru.yandex.travel.hotels.common.partners.bronevik.HotelOfferCancellationPolicy
import ru.yandex.travel.hotels.common.partners.bronevik.HotelRoom
import ru.yandex.travel.hotels.common.partners.bronevik.HotelRooms
import ru.yandex.travel.hotels.common.partners.bronevik.Image
import ru.yandex.travel.hotels.common.partners.bronevik.Order
import ru.yandex.travel.hotels.common.partners.bronevik.OrderServiceAccommodation
import ru.yandex.travel.hotels.common.partners.bronevik.OrderServices
import ru.yandex.travel.hotels.common.partners.bronevik.Orders
import ru.yandex.travel.hotels.common.partners.bronevik.Photos
import ru.yandex.travel.hotels.common.partners.bronevik.PriceDetails
import ru.yandex.travel.hotels.common.partners.bronevik.SearchOrdersResponse
import ru.yandex.travel.hotels.common.partners.bronevik.model.BedType.DOUBLE
import ru.yandex.travel.hotels.common.partners.bronevik.model.MealsDevelopment
import ru.yandex.travel.hotels.common.partners.bronevik.model.OrderStatus
import java.time.Instant
import java.util.UUID
import javax.xml.datatype.DatatypeFactory

object MockUtils {
    fun mockGetHotelOfferPricingResponse(price: Float): GetHotelOfferPricingResponse {
        val getHotelOfferPricingResponse = GetHotelOfferPricingResponse()
        val services = mockOrderServices(price, null)

        getHotelOfferPricingResponse.services = services

        return getHotelOfferPricingResponse
    }

    fun mockCreateOrderResponse(price: Float, status: OrderStatus): CreateOrderResponse {
        val createOrderResponse = CreateOrderResponse()
        val order = mockOrder(price, status)

        createOrderResponse.order = order

        return createOrderResponse
    }

    fun mockGetOrderResponse(price: Float, status: OrderStatus): GetOrderResponse {
        val getOrderResponse = GetOrderResponse()
        val order = mockOrder(price, status)

        getOrderResponse.order = order

        return getOrderResponse
    }

    private fun mockOrder(price: Float, status: OrderStatus): Order {
        val order = Order()
        val services = mockOrderServices(price, status)

        order.services = services
        order.id = 49

        return order
    }

    private fun mockOrderServices(
        price: Float,
        status: OrderStatus?,
        offerCode: String = UUID.randomUUID().toString()
    ): OrderServices {
        val services = OrderServices()
        val service = OrderServiceAccommodation()
        val priceDetails = PriceDetails()
        priceDetails.client = mockClientPriceDetails(price.toDouble())
        service.priceDetails = priceDetails
        service.offerCode = offerCode

        status?.let {
            service.statusId = it.value
        }

        services.service = listOf(service)

        return services
    }

    fun mockCancelOrderResponse(): CancelOrderResponse {
        val cancelOrderResponse = CancelOrderResponse()

        cancelOrderResponse.isResult = true

        return cancelOrderResponse
    }

    fun mockSearchOrdersResponse(price: Float, status: OrderStatus, offerCode: String? = null): SearchOrdersResponse {
        val searchOrdersResponse = SearchOrdersResponse()
        val orders: MutableList<Order> = mutableListOf()

        offerCode?.let {
            val order = Order()
            order.id = 123
            order.services = mockOrderServices(price, status, it)
            orders.add(order)
        }

        val ordersWrapper = Orders()
        ordersWrapper.order = orders
        searchOrdersResponse.orders = ordersWrapper

        return searchOrdersResponse
    }

    fun mockGetHotelOfferPricingFault(code: Int): BronevikException {
        val details = FaultDetail()

        details.code = code

        return mockGetBronevikException(GetHotelOfferPricingFault("Mocked Exception with code: $code", details))
    }

    fun<T: Throwable> mockGetBronevikException(fault: T): BronevikException {

        return BronevikException(fault)
    }

    fun mockCreateOrderFault(code: Int): BronevikException {
        val details = FaultDetail()

        details.code = code

        return mockGetBronevikException(CreateOrderFault("Mocked Exception with code: $code", details))
    }

    fun mockHotelRooms(): HotelRooms {
        val hotelRooms = HotelRooms()
        val hotelRoom = HotelRoom()
        hotelRoom.id = 1001
        hotelRoom.name = "Тестовая комната"
        hotelRoom.description = "Тестовая сгенерированная комната в тестовом сгенерированном отеле"
        hotelRoom.photos = mockPhotos()
        hotelRoom.roomCapacity = 2

        val bedSets = BedSets()
        val bedSet = BedSet()
        val bed = Bed()
        bed.amount = 1
        bed.type = DOUBLE.value
        bedSet.bed = listOf(bed)
        bedSets.bedSet = listOf(bedSet)
        hotelRoom.availableBedSets = bedSets
        hotelRooms.room = listOf(hotelRoom)

        return hotelRooms
    }

    fun mockDescriptionDetails(): DescriptionDetails {
        val descriptionDetails = DescriptionDetails()
        val availableAmenities = AvailableAmenities()
        val availableAmenity = AvailableAmenity()
        availableAmenity.id = 1001002
        availableAmenity.isIncluded = true
        availableAmenities.availableAmenity = listOf(availableAmenity)
        descriptionDetails.availableAmenities = availableAmenities
        descriptionDetails.photos = mockPhotos()
        descriptionDetails.description = "Тестовый отель, сгенерирован тестовым контекстом, для тестового " +
            "тестирования тестировщиками. В реальности не существует"
        descriptionDetails.latitude = "55.734399"
        descriptionDetails.longitude = "37.587293"

        return descriptionDetails
    }

    private fun mockPhotos(): Photos {
        val photos = Photos()
        val image1 = Image()
        image1.url = "https://avatars.mds.yandex.net/get-altay/223006/2a0000015b19222d131711047d866611eaf2/XXXL"
        val image2 = Image()
        image2.url = "https://avatars.mds.yandex.net/get-altay/223006/2a0000015b19222d131711047d866611eaf2/XXXL"
        photos.photo = listOf(image1, image2)

        return photos
    }

    fun mockClientPriceDetails(price: Double): ClientPriceDetails {
        val clientPriceDetails = ClientPriceDetails()
        val clientCurrency = CurrencyPriceDetails()
        val detailedPrice = DetailedPrice()
        detailedPrice.currency = "RUB"
        detailedPrice.price = price.toFloat()
        clientCurrency.gross = detailedPrice
        clientPriceDetails.clientCurrency = clientCurrency

        return clientPriceDetails
    }

    fun mockHotelOfferCancellationPolicy(startAt: Instant, penalty: Float): HotelOfferCancellationPolicy {
        val policy = HotelOfferCancellationPolicy()
        policy.penaltyDateTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(startAt.toString())
        policy.penaltyPriceDetails = mockClientPriceDetails(penalty.toDouble())

        return policy
    }

    fun mockSearchOrderResponse(price: Float, status: OrderStatus, offerCode: String?): SearchOrdersResponse {
        val searchOrdersResponse = SearchOrdersResponse()
        val orders: MutableList<Order> = mutableListOf()

        offerCode?.let {
            val order = Order()
            order.id = 123
            order.services = mockOrderServices(price, status, it)
            orders.add(order)
        }

        val ordersWrapper = Orders()
        ordersWrapper.order = orders
        searchOrdersResponse.orders = ordersWrapper

        return searchOrdersResponse
    }

    fun mockMeal(type: MealsDevelopment, isIncluded: Boolean): AvailableMeal {
        return mockMeal(type, isIncluded, 0)
    }

    fun mockMeal(type: MealsDevelopment, isIncluded: Boolean, vat: Int): AvailableMeal {
        return mockMeal(type, isIncluded, 0, mockClientPriceDetails(200.00))
    }

    fun mockMeal(type: MealsDevelopment, isIncluded: Boolean, vat: Int, clientPriceDetails: ClientPriceDetails): AvailableMeal {
        val meal = AvailableMeal()
        meal.isIncluded = isIncluded
        meal.id = type.value
        meal.vatPercent = vat
        meal.priceDetails = clientPriceDetails
        return meal
    }

    fun mockIncludedDinnerNotFullBoardBreakfast(): AvailableMeals {
        val meals: MutableList<AvailableMeal> = mutableListOf(
            mockMeal(MealsDevelopment.DINNER, true, 20),
            mockMeal(MealsDevelopment.BUFFET_BREAKFAST, false, 20),
            mockMeal(MealsDevelopment.FULL_BOARD, false, 20)
        )

        val gettedAvailableMeals = AvailableMeals()
        gettedAvailableMeals.meal = meals
        return gettedAvailableMeals
    }

    fun mockNotIncludedFullBoardBreakfastDinner(): AvailableMeals {
        val meals: MutableList<AvailableMeal> = mutableListOf(
            mockMeal(MealsDevelopment.DINNER, false, 20),
            mockMeal(MealsDevelopment.BUFFET_BREAKFAST, false, 20),
            mockMeal(MealsDevelopment.FULL_BOARD, false, 20)
        )

        val gettedAvailableMeals = AvailableMeals()
        gettedAvailableMeals.meal = meals
        return gettedAvailableMeals
    }
    fun mockNotIncludedFullBoard(): AvailableMeals {
        val meals: MutableList<AvailableMeal> = mutableListOf(
            mockMeal(MealsDevelopment.FULL_BOARD, false, 20, mockClientPriceDetails(300.00))
        )

        val gettedAvailableMeals = AvailableMeals()
        gettedAvailableMeals.meal = meals
        return gettedAvailableMeals
    }
}
