package ru.yandex.travel.hotels.common.partners.bronevik.utils.timezone;

import java.time.ZoneOffset;
import java.util.TimeZone;
import ru.yandex.travel.hotels.common.partners.bronevik.proto.THotelTimezone;

public interface BronevikHotelTimezone {
    String getTimezoneID(String hotelId);

    THotelTimezone getHotelTimezone(String hotelId);

    default ZoneOffset getZoneOffset(String hotelId) {
        var ONE_SECOND = 1000;
        var zone = getTimeZone(hotelId);
        return  ZoneOffset.ofTotalSeconds(zone.getRawOffset() / ONE_SECOND);
    };

    default TimeZone getTimeZone(String hotelId) {
        var timezoneID = getHotelTimezone(hotelId).getTimezoneId();
        return TimeZone.getTimeZone(timezoneID);
    };
}
