package ru.yandex.travel.hotels.common.partners.dolphin;

import java.time.Duration;
import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@Validated
@ConfigurationProperties(prefix = "yt.cache.dolphin", ignoreUnknownFields = false)
public class BaseDolphinYtCacheProperties {
    @NotNull
    private Duration updateInterval;
    @NotEmpty
    private List<String> proxy;
    @NotEmpty
    private String token;
    @NotEmpty
    private String baseYtPath;
    @NotEmpty
    private String baseLocalPath;
}
