package ru.yandex.travel.hotels.common.partners.dolphin;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.dolphin.model.AnnulateResult;
import ru.yandex.travel.hotels.common.partners.dolphin.model.Area;
import ru.yandex.travel.hotels.common.partners.dolphin.model.AreaType;
import ru.yandex.travel.hotels.common.partners.dolphin.model.CalculateOrderRequest;
import ru.yandex.travel.hotels.common.partners.dolphin.model.CalculateOrderResponse;
import ru.yandex.travel.hotels.common.partners.dolphin.model.CreateOrderRequest;
import ru.yandex.travel.hotels.common.partners.dolphin.model.HotelContent;
import ru.yandex.travel.hotels.common.partners.dolphin.model.IdNameMap;
import ru.yandex.travel.hotels.common.partners.dolphin.model.Order;
import ru.yandex.travel.hotels.common.partners.dolphin.model.OrderList;
import ru.yandex.travel.hotels.common.partners.dolphin.model.OrdersInfoRequest;
import ru.yandex.travel.hotels.common.partners.dolphin.model.Pansion;
import ru.yandex.travel.hotels.common.partners.dolphin.model.SearchResponse;
import ru.yandex.travel.hotels.common.partners.dolphin.model.TourContent;
import ru.yandex.travel.hotels.common.token.Occupancy;

import static ru.yandex.travel.hotels.common.partners.base.Helpers.sync;

public interface DolphinClient {
    CompletableFuture<HotelContent> getHotelContent(String hotelId);

    default HotelContent getHotelContentSync(String hotelId) {
        return sync(getHotelContent(hotelId));
    }

    CompletableFuture<IdNameMap> getRooms();

    default IdNameMap getRoomsSync() {
        return sync(getRooms());
    }

    CompletableFuture<IdNameMap> getRoomCategories();

    default IdNameMap getRoomCategories0Sync() {
        return sync(getRoomCategories());
    }

    CompletableFuture<TourContent> getTourContent(String tourId);

    default TourContent getTourContentSync(String tourId) {
        return sync(getTourContent(tourId));
    }

    CompletableFuture<Map<AreaType, Map<Long, Area>>> getAreaMap();

    default Map<AreaType, Map<Long, Area>> getAreaMapSync() {
        return sync(getAreaMap());
    }

    CompletableFuture<Order> createOrder(CreateOrderRequest request);

    default Order createOrderSync(CreateOrderRequest request) {
        return sync(createOrder(request));
    }

    CompletableFuture<Map<Long, Pansion>> getPansionMap();

    default Map<Long, Pansion> getPansionMapSync() {
        return sync(getPansionMap());
    }

    CompletableFuture<SearchResponse> searchCheckins(LocalDate checkin, LocalDate checkout, Occupancy occupancy,
                                                     List<String> hotelIds, String httpRequestId);

    CompletableFuture<CalculateOrderResponse> calculateOrder(CalculateOrderRequest request);

    default CalculateOrderResponse calculateOrderSync(CalculateOrderRequest request) {
        return sync(calculateOrder(request));
    }

    CompletableFuture<AnnulateResult> annulateOrder(String id);

    default AnnulateResult annulateOrderSync(String id) {
        return sync(annulateOrder(id));
    }

    CompletableFuture<OrderList> getOrders(OrdersInfoRequest request);

    default OrderList getOrdersSync(OrdersInfoRequest request) {
        return sync(getOrders(request));
    }

    CompletableFuture<Order> getOrder(String id);

    default Order getOrderSync(String id) {
        return sync(getOrder(id));
    }

    default DolphinClient withCallContext(CallContext callContext) {
        return new CallContextDolphinClient(this, callContext);
    }
}
