package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class AreaList extends ArrayList<Area> {
    public Map<AreaType, Map<Long, Area>> toMap() {
        Map<AreaType, Map<Long, Area>> result = new HashMap<>(this.size());
        for (Area item : this) {
            result.computeIfAbsent(item.getType(), (k) -> new HashMap<>()).put(item.getId(), item);
        }
        return ImmutableMap.copyOf(result);
    }
}
