package ru.yandex.travel.hotels.common.partners.dolphin.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum AreaType {
    Country("Country"),
    Region("Region"),
    City("City"),
    District("Distinct");

    private String value;

    AreaType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static AreaType fromString(String value) {
        for (AreaType candidate : AreaType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown area type %s", value)
        );
    }
}
