package ru.yandex.travel.hotels.common.partners.dolphin.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum CheckinServiceModeEnum {
    EMPTY(""), CSM_24_7("24/7"), CSM_SELECTION("selection");

    private String value;

    CheckinServiceModeEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static CheckinServiceModeEnum fromString(String value) {
        for (CheckinServiceModeEnum candidate : CheckinServiceModeEnum.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown checkin-service mode %s", value));
    }
}
