package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.Singular;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Data
@EqualsAndHashCode(callSuper = false, of = {"guests", "adults", "priceKey"})
@Builder
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateOrderRequest extends AuthorizedRequest {
    @JsonProperty("Adults")
    int adults;

    @JsonProperty("PriceKey")
    private PriceKey priceKey;

    @JsonProperty("ChildAges")
    private List<Integer> children;

    @JsonProperty("Guests")
    @Singular
    private List<Guest> guests;

    @JsonProperty("Email")
    @PersonalData
    private String email;

    @JsonProperty("Phone")
    @PersonalData
    private String phone;
}
