package ru.yandex.travel.hotels.common.partners.dolphin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ExtendState {
    DOUBLE_BOOKING("DoubleBooking"),
    PENALTY("Удержание");

    private String value;

    ExtendState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ExtendState fromString(String value) {
        for (ExtendState candidate : ExtendState.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown order extend state %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
