package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import ru.yandex.travel.commons.logging.masking.PersonalData;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@JsonSerialize
@JsonInclude(JsonInclude.Include.NON_NULL)
@EqualsAndHashCode(of = "cyrillic")
public class Guest {
    private final static String RUS = "RUS";

    @JsonProperty("Id")
    private Long id;

    @JsonProperty("Birthday")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_DATE_PATTERN)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonSerialize(using = LocalDateSerializer.class)
    @PersonalData
    private LocalDate dateOfBirth;

    @JsonProperty("DocumentNumber")
    @PersonalData
    private String passportNumber;

    @JsonProperty("DocumentSerial")
    @PersonalData
    private String passportSerie;

    @JsonProperty("IsMale")
    private Boolean isMale;

    @JsonProperty("Citizenship")
    @PersonalData
    private String citizenship;

    @JsonProperty("Phone")
    @PersonalData
    private String phone;

    @JsonProperty("Cyrilic")
    private GuestName cyrillic;

    @JsonProperty("Latin")
    private GuestName latin;


    public static Guest createCyrillic(String firstName, String lastName) {
        GuestName name = new GuestName();
        name.setFirstName(firstName);
        name.setLastName(lastName);
        return Guest.builder()
                .cyrillic(name)
                .isMale(true)
                .citizenship(RUS)
                .build();
    }
}
