package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GuestName {
    @JsonProperty("Name")
    @PersonalData
    private String firstName;

    @JsonProperty("SurName")
    @PersonalData
    private String lastName;

    @JsonProperty("Patronymic")
    @PersonalData
    private String patronymicName;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GuestName guestName = (GuestName) o;
        return firstName.equalsIgnoreCase(guestName.firstName) &&
                lastName.equalsIgnoreCase(guestName.lastName) &&
                Strings.nullToEmpty(patronymicName).equalsIgnoreCase(Strings.nullToEmpty(guestName.patronymicName));
    }

    @Override
    public int hashCode() {
        return Objects.hash(firstName, lastName, Strings.nullToEmpty(patronymicName));
    }
}
