package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;

@Data
@JsonIgnoreProperties({"Tours", "NameAdd"})
public class HotelContent {
    @Data
    public class Service {
        @JsonProperty("Type")
        private String type;

        @JsonProperty("Description")
        private String description;

        @JsonProperty("IsPaid")
        private boolean isPaid;
    }


    @JsonProperty("Id")
    private long id;

    @JsonProperty("Name")
    private String name;

    @JsonProperty("Type")
    private String type;

    @JsonProperty("Stars")
    private int stars;

    @JsonProperty("Country")
    private long countryId;

    @JsonProperty("Region")
    private long regionId;

    @JsonProperty("City")
    private long cityId;

    @JsonProperty("Distinct")
    private long districtId;

    @JsonProperty("Adress")
    private String address;

    @JsonProperty("Latitude")
    private double latitude;

    @JsonProperty("Longitude")
    private double longitude;

    @JsonProperty("CheckinTime")
    private String checkinTime;

    @JsonProperty("CheckoutTime")
    private String checkoutTime;

    @JsonProperty("CheckinServiceMode")
    private CheckinServiceModeEnum checkinServiceMode;

    @JsonProperty("CheckinServiceFrom")
    private String checkinServiceFrom;

    @JsonProperty("CheckinServiceTill")
    private String checkinServiceTill;

    @JsonProperty("ConstructionInfo")
    private String constructionInfo;

    @JsonProperty("Contacts")
    private String contacts;

    @JsonProperty("Info")
    private String info;

    @JsonProperty("TransportAccessability")
    private String transportAccessibility;

    @JsonProperty("Photos200x150")
    private List<String> photos200x150;

    @JsonProperty("Photos800x600")
    private List<String> photos800x600;

    @JsonProperty("Photos1020x700")
    private List<String> photos1020x700;

    @JsonProperty("Services")
    private List<Service> services;
}
