package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class Offer {
    @JsonProperty("Room")
    private long roomId;

    @JsonProperty("RoomCat")
    private long categoryId;

    @JsonProperty("IsQuoted")
    private boolean isQuoted;

    @JsonProperty("Price")
    private double price;

    @JsonProperty("Places")
    private int places;

    @JsonProperty("Discounts")
    private double discount;

    @JsonProperty("Beds")
    private List<Integer> beds;

    @JsonProperty("Rate")
    private String rate;

    public boolean checkAllowed() {
        return discount >= 0;
    }
}
