package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import lombok.Data;

import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OfferList {
    @JsonProperty("Pansion")
    private long pansionId;

    @JsonProperty("Hotel")
    private long hotelId;

    @JsonProperty("Tour")
    private long tourId;

    @JsonProperty("Date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_DATE_PATTERN)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    private LocalDate date;

    @JsonProperty("Nights")
    private int nights;

    @JsonProperty("Offers")
    private List<Offer> offers;
}
