package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import lombok.Data;

import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class Order {
    @JsonProperty("Code")
    private String code;

    @JsonProperty("State")
    private OrderState state;

    @JsonProperty("Cost")
    private Cost cost;

    @JsonProperty("Services")
    private List<TourService> serviceList;

    @JsonProperty("Request")
    private CreateOrderRequest request;

    @JsonProperty("ExtendState")
    private ExtendState extendState;

    @JsonProperty("CreateDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_INSTANT_PATTERN,
            timezone = Formatters.DOLPHIN_DEFAULT_TIMEZONE)
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    private LocalDateTime createDate;

}
