package ru.yandex.travel.hotels.common.partners.dolphin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OrderState {
    UNDEFINED("Undefined"),
    IN_WORK("InWork"),
    ANNULATED("Annulated"),
    REBOOKING("Rebooking"),
    WAIT_LIST("WaitList"),
    OK("Ok");

    private String value;

    OrderState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static OrderState fromString(String value) {
        for (OrderState candidate : OrderState.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown order state %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
