package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Singular;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OrdersInfoRequest extends AuthorizedRequest {
    @JsonProperty("Code")
    private String code;
    @JsonProperty("CheckinPeriod")
    private QueryPeriod checkinPeriod;
    @JsonProperty("CreatePeriod")
    private QueryPeriod createPeriod;
    @JsonProperty("HotelPeriod")
    private QueryPeriod hotelPeriod;
    @JsonProperty("States")
    @Singular
    private List<OrderState> states;
    @JsonProperty("TouristNameLike")
    private String touristNameLike;
}
