package ru.yandex.travel.hotels.common.partners.dolphin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;

import ru.yandex.travel.hotels.proto.EPansionType;

@Data
public class Pansion {
    @JsonProperty("Id")
    private long id;

    @JsonProperty("Name")
    private String name;

    @JsonProperty("ParentId")
    @Getter(value = AccessLevel.PRIVATE)
    private int type;

    public EPansionType getPansionType() {
        switch (type) {
            case 0:
                return EPansionType.PT_RO;
            case 1:
                return EPansionType.PT_BB;
            case 2:
                return EPansionType.PT_HB;
            case 3:
            case 4:
            case 5:
            case 6:
                return EPansionType.PT_FB;
            case 8:
                return EPansionType.PT_AI;
            case 10:
                return EPansionType.PT_BD;
            case -1:
                if (id == 188) {
                    return EPansionType.PT_HB;
                }
                if (id == 189 || id == 190) {
                    return EPansionType.PT_BB;
                }
                if (id == 194) {
                    return EPansionType.PT_FB;
                }
                break;
        }
        return EPansionType.PT_UNKNOWN;
    }
}
