package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PriceKey {
    @JsonProperty("Hotel")
    private long hotelId;

    @JsonProperty("Tour")
    private long tourId;

    @JsonProperty("Pansion")
    private long pansionId;

    @JsonProperty("Room")
    private long roomId;

    @JsonProperty("RoomCat")
    private long roomCategoryId;

    @JsonProperty("Date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_DATE_PATTERN)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonSerialize(using = LocalDateSerializer.class)
    private LocalDate date;

    @JsonProperty("Nights")
    private int nights;

    @JsonProperty("Beds")
    private List<Integer> beds;
}
