package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryPeriod {
    @JsonProperty("Start")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_DATE_PATTERN)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonSerialize(using = LocalDateSerializer.class)
    private LocalDate start;

    @JsonProperty("Stop")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_DATE_PATTERN)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonSerialize(using = LocalDateSerializer.class)
    private LocalDate stop;
}
