package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
public class SearchRequest {
    @JsonProperty("CheckInDates")
    private List<String> checkinDates;
    @JsonProperty("Nights")
    private List<Integer> nights;
    @JsonProperty("Adults")
    private int adults;
    @JsonProperty("ChildAges")
    private List<Integer> childAges;
    @JsonProperty("Params")
    private Params params;
    @JsonProperty("AllowUnquoted")
    private boolean allowUnquoted;
    @JsonProperty("Access")
    private CaseFields access;

    public static SearchRequest build(LocalDate checkin, LocalDate checkout, int numAdults, List<Integer> childAges,
                                      List<String> hotelIds, String login, String password) {
        int nights = (int) ChronoUnit.DAYS.between(checkin, checkout);
        String checkinDateString = Formatters.DOLPHIN_DATE_FORMATTER.format(checkin);
        var result = new SearchRequest();
        result.setCheckinDates(Collections.singletonList(checkinDateString));
        result.setNights(Collections.singletonList(nights));
        result.setAdults(numAdults);
        result.setChildAges(childAges.stream()
                .sorted((a, b) -> Integer.compare(b, a))
                .collect(Collectors.toList()));
        result.setParams(new SearchRequest.Params(
                new CaseFields("Hotels", Collections.singletonList(hotelIds)),
                List.of(60, 17)));
        result.setAllowUnquoted(false);
        result.setAccess(new CaseFields("LoginPass", List.of(login, password)));
        return result;
    }

    @Value
    public static class Params {
        @JsonProperty("Location")
        private final CaseFields location;

        @JsonProperty("TourTypes")
        private final List<Integer> tourTypes;
    }
}
