package ru.yandex.travel.hotels.common.partners.dolphin.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import lombok.Data;

import ru.yandex.travel.hotels.common.partners.dolphin.utils.Formatters;

@Data
public class TourService {
    @JsonProperty("Type")
    private String type;

    @JsonProperty("Name")
    private String name;

    @JsonProperty("StartDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Formatters.DOLPHIN_DATE_PATTERN)
    @JsonDeserialize(using = LocalDateDeserializer.class)
    private LocalDate startDate;

    @JsonProperty("Persons")
    private int persons;

    @JsonProperty("IsDeletable")
    private boolean isDeletable;

    @JsonProperty("IsInvisible")
    private boolean isInvisible;

    @JsonProperty("Duration")
    private int durationDays;

    @JsonProperty("Brutto")
    private double brutto;

    @JsonProperty("Fee")
    private double fee;


}
