package ru.yandex.travel.hotels.common.partners.dolphin.utils;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;

import ru.yandex.travel.hotels.common.partners.dolphin.model.IdNameMap;

public class IdNameMapDeserializer extends StdDeserializer<Map<Long, String>> {
    protected IdNameMapDeserializer() {
        super(IdNameMap.class);
    }

    @Override
    public Map<Long, String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Map<Long, String> result = new IdNameMap();
        var node = p.getCodec().readTree(p);
        if (!node.isArray()) {
            throw new JsonParseException(p, "Node is not an array");
        }

        for (var child : (ArrayNode)node) {
            if (!child.has("Id")) {
                throw new JsonParseException(p, "'Id' field is not found");
            }
            if (!child.has("Name")) {
                throw new JsonParseException(p, "'Name' field is not found");
            }
            var id = child.get("Id").longValue();
            var name = child.get("Name").asText();
            if (result.containsKey(id)) {
                throw new JsonParseException(p, String.format("Duplicate key '%s'", id));
            }
            result.put(id, name);
        }
        return result;
    }
}
