package ru.yandex.travel.hotels.common.partners.dolphin.utils;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.health.HealthChecked;
import ru.yandex.travel.hotels.common.partners.dolphin.proto.TNormalizeRule;

@RequiredArgsConstructor
public class RoomNameNormalizer implements HealthChecked {

    private final RoomNameNormalizerRules normalizeRules;

    public String normalize(String input) {
        var rules = normalizeRules.getAll();
        for (TNormalizeRule rule : rules) {
            input = input.replace(rule.getFrom(), rule.getTo());
        }
        return input.trim();
    }

    @Override
    public boolean isHealthy() {
        return normalizeRules.isReady();
    }
}
