package ru.yandex.travel.hotels.common.partners.dolphin.utils;

import java.util.Comparator;
import java.util.function.Function;

import ru.yandex.travel.hotels.common.partners.dolphin.BaseDolphinYtCacheProperties;
import ru.yandex.travel.hotels.common.partners.dolphin.proto.TNormalizeRule;
import ru.yandex.travel.yt_lucene_index.ListPersistentConfig;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

public class RoomNameNormalizerRules extends ListPersistentConfig<TNormalizeRule, TNormalizeRule> {

    public static final String ROOM_NORMALIZE_RULES = "room_normalize_rules";

    public RoomNameNormalizerRules(YtLuceneIndexParams params, String name) {
        super(params, name, TNormalizeRule::newBuilder, Function.identity(), (rules) -> {
            rules.sort(Comparator.comparingInt(TNormalizeRule::getId));
            return rules;
        });
    }

    public static RoomNameNormalizerRules fromBaseProperties(BaseDolphinYtCacheProperties properties) {
        YtLuceneIndexParams params = new YtLuceneIndexParams();
        params.setProxy(properties.getProxy());
        params.setToken(properties.getToken());
        params.setUpdateInterval(params.getUpdateInterval());
        params.setTablePath(properties.getBaseYtPath() + "/" + ROOM_NORMALIZE_RULES);
        params.setIndexPath(properties.getBaseLocalPath() + "/" + ROOM_NORMALIZE_RULES + "-index");
        return new RoomNameNormalizerRules(params, ROOM_NORMALIZE_RULES);
    }
}
