package ru.yandex.travel.hotels.common.partners.expedia;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ApiVersion {
    V2_4("2.4"),
    V3("v3");


    private final String value;

    ApiVersion(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ApiVersion fromString(String value) {
        for (var candidate : ApiVersion.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ApiVersion %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
