package ru.yandex.travel.hotels.common.partners.expedia;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Data
@AllArgsConstructor
public class ExpediaAuthenticationInfo {
    private String apiKey;
    private String apiSecret;

    public String getAuthenticationString() {
        Long timestamp = System.currentTimeMillis() / 1000;
        String signature;
        try {
            String toBeHashed = apiKey + apiSecret + timestamp;
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] bytes = md.digest(toBeHashed.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(Integer.toString((aByte & 0xff) + 0x100, 16).substring(1));
            }
            signature = sb.toString();
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to generate Expedia Authorization header", e);
        }
        return "EAN APIKey=" + apiKey + ",Signature=" + signature + ",timestamp=" + timestamp;
    }
}
