package ru.yandex.travel.hotels.common.partners.expedia;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.IdNameValue;
import ru.yandex.travel.hotels.common.partners.expedia.model.content.PropertyContent;
import ru.yandex.travel.hotels.common.partners.expedia.model.shopping.ShoppingRate;

public enum KnownAmenity {
    //MEALS
    ALL_MEALS(2102),
    CONTINENTAL_BREAKFAST(2103),
    FULL_BREAKFAST(2104),
    ENGLISH_BREAKFAST(2105),
    FREE_LUNCH(2106),
    FREE_DINNER(2107),
    ALL_INCLUSIVE(2111),
    CONTINENTAL_BREAKFAST_FOR_TWO(2193),
    BREAKFAST_FOR_TWO(2194),
    BREAKFAST_BUFFET(2205),
    HALF_BOARD(2206),
    FULL_BOARD(2207),
    FULL_KITCHEN(2208),
    FREE_BREAKFAST(1073742786),
    BREAKFAST_FOR_ONE(1073742857),
    // WIFI
    FREE_WIRELESS_INTERNET(2192),
    FREE_WIFI(2403),
    WIFI_WTH_SURCHARGE(2404),
    // SPA
    SPA_ACCESS(1073742618);


    public static EnumSet<KnownAmenity> BREAKFASTS = EnumSet.of(
            CONTINENTAL_BREAKFAST,
            FULL_BREAKFAST,
            ENGLISH_BREAKFAST,
            CONTINENTAL_BREAKFAST_FOR_TWO,
            BREAKFAST_FOR_TWO,
            BREAKFAST_BUFFET,
            FREE_BREAKFAST,
            BREAKFAST_FOR_ONE);

    public static EnumSet<KnownAmenity> FULL_BOARDS = EnumSet.of(FULL_BOARD, ALL_MEALS);

    private long code;

    KnownAmenity(long code) {
        this.code = code;
    }

    public static KnownAmenity fromCode(long code) {
        for (KnownAmenity candidate : KnownAmenity.values()) {
            if (candidate.getCode() == code) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown mean code %d", code)
        );
    }

    private static KnownAmenity fromStringCode(String key) {
        try {
            long amenityId = Long.parseLong(key);
            return fromCode(amenityId);
        } catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Set<KnownAmenity> fromPropertyContent(PropertyContent content, String rateId) {
        if (rateId != null && content.getRates().containsKey(rateId) && content.getRates().get(rateId).getAmenities() != null) {
            Set<KnownAmenity> results = content.getRates().get(rateId).getAmenities().keySet().stream()
                    .map(KnownAmenity::fromStringCode)
                    .filter(Objects::nonNull)
                    .collect(Collectors.toSet());
            if (results.isEmpty()) {
                return EnumSet.noneOf(KnownAmenity.class);
            } else {
                return EnumSet.copyOf(results);
            }
        } else {
            return EnumSet.noneOf(KnownAmenity.class);
        }
    }

    public static Set<KnownAmenity> fromShoppingRate(ShoppingRate rate) {
        if (rate.getAmenities() == null) {
            return EnumSet.noneOf(KnownAmenity.class);
        }
        Set<KnownAmenity> results = rate.getAmenities().values().stream()
                .map(IdNameValue::getId)
                .map(KnownAmenity::fromStringCode)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());
        if (results.isEmpty()) {
            return EnumSet.noneOf(KnownAmenity.class);
        } else {
            return EnumSet.copyOf(results);
        }
    }

    public long getCode() {
        return this.code;
    }

}
