package ru.yandex.travel.hotels.common.partners.expedia;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.hotels.common.partners.expedia.model.content.PropertyContent;


@AllArgsConstructor
public enum KnownPropertyAmenity {
    //PROPERTY LEVEL AMENITIES

    // Values here should be same as in https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/feeders/partners/expedia/lib/expedia.py?rev=6597790#L178
    FREE_SELF_SERVE_BREAKFAST(1073744141),
    FREE_KOREAN_BREAKFAST(1073744462),
    FREE_JAPANESE_BREAKFAST(1073744464),
    FREE_TAIWANESE_BREAKFAST(1073744465),
    FREE_CANTONESE_BREAKFAST(1073744466),
    FREE_BREAKFAST(2001);

    public static EnumSet<KnownPropertyAmenity> BREAKFASTS = EnumSet.of(
            FREE_SELF_SERVE_BREAKFAST,
            FREE_KOREAN_BREAKFAST,
            FREE_JAPANESE_BREAKFAST,
            FREE_TAIWANESE_BREAKFAST,
            FREE_CANTONESE_BREAKFAST,
            FREE_BREAKFAST);

    @Getter
    private final long code;

    public static KnownPropertyAmenity fromCode(long code) {
        for (KnownPropertyAmenity candidate : KnownPropertyAmenity.values()) {
            if (candidate.getCode() == code) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown mean code %d", code)
        );
    }

    private static KnownPropertyAmenity fromStringCode(String key) {
        try {
            long amenityId = Long.parseLong(key);
            return fromCode(amenityId);
        } catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Set<KnownPropertyAmenity> fromPropertyContent(PropertyContent content) {
        return content.getAmenities().keySet().stream()
                .map(KnownPropertyAmenity::fromStringCode)
                .filter(Objects::nonNull)
                .collect(Collectors.toUnmodifiableSet());
    }
}
