package ru.yandex.travel.hotels.common.partners.expedia;

import java.util.Set;

import ru.yandex.travel.hotels.common.pansions.PansionUnifier;
import ru.yandex.travel.hotels.proto.EPansionType;

public class Pansions {
    public static EPansionType combinePansionType(EPansionType propertyPansion, EPansionType ratePansion) {
        if (ratePansion == EPansionType.PT_RO && propertyPansion != null) {
            return propertyPansion;
        }
        return ratePansion;
    }

    public static EPansionType getPansionType(Set<KnownAmenity> amenities) {
        if (amenities.isEmpty()) {
            return EPansionType.PT_RO;
        }
        boolean fullBoard = false;
        boolean halfBoard = false;
        boolean breakfastIncluded = false;
        boolean lunchIncluded = false;
        boolean dinnerIncluded = false;
        boolean allInclusive = false;


        for (KnownAmenity amenity : amenities) {
            if (KnownAmenity.BREAKFASTS.contains(amenity)) {
                breakfastIncluded = true;
            }
            if (amenity == KnownAmenity.FREE_LUNCH) {
                lunchIncluded = true;
            }
            if (amenity == KnownAmenity.FREE_DINNER) {
                dinnerIncluded = true;
            }
            if (amenity == KnownAmenity.HALF_BOARD) {
                halfBoard = true;
            }
            if (KnownAmenity.FULL_BOARDS.contains(amenity)) {
                fullBoard = true;
            }
            if (amenity == KnownAmenity.ALL_INCLUSIVE) {
                allInclusive = true;
            }
        }
        return PansionUnifier.get(allInclusive, fullBoard, halfBoard, breakfastIncluded, lunchIncluded, dinnerIncluded);
    }

    public static EPansionType getPropertyPansionType(Set<KnownPropertyAmenity> amenities) {
        for (var amenity : amenities) {
            if (KnownPropertyAmenity.BREAKFASTS.contains(amenity)) {
                return EPansionType.PT_BB;
            }
        }
        return EPansionType.PT_RO;
    }
}
