package ru.yandex.travel.hotels.common.partners.expedia.exceptions;

import java.math.BigDecimal;
import java.text.MessageFormat;

public class PriceSumMismatchException extends RuntimeException {
    private BigDecimal ourSum;
    private BigDecimal expediaSum;

    public PriceSumMismatchException(BigDecimal ourSum, BigDecimal expediaSum) {
        super(MessageFormat.format("Total rates do no match: our sum is {0}, expedia's sum is {1}",
                ourSum.toString(), expediaSum.toString()));
        this.ourSum = ourSum;
        this.expediaSum = expediaSum;
    }
}
