package ru.yandex.travel.hotels.common.partners.expedia.exceptions;

import lombok.Getter;
import lombok.Setter;
import org.asynchttpclient.Response;

import java.util.Map;
import java.util.Set;

@Getter
public class UnexpectedHttpStatusCodeException extends RuntimeException {
    private final int statusCode;
    private final Map<String, Object> errorDetails;


    public UnexpectedHttpStatusCodeException(int statusCode, Map<String, Object> errorDetails) {
        super(String.format("Unexpected HTTP status code '%s'", statusCode));
        this.errorDetails = errorDetails;
        this.statusCode = statusCode;
    }
}
