package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Address;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = BillingContact.BillingContactBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BillingContact {
    private String givenName;
    private String familyName;
    private Address address;

    @JsonPOJOBuilder(withPrefix = "")
    public static class BillingContactBuilder {
    }
}
