package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.math.BigDecimal;
import java.time.Instant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Deserializers;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = DepositPolicy.DepositPolicyBuilder.class)
public class DepositPolicy {
    private Integer nights;
    private BigDecimal amount;
    private BigDecimal percent;
    private Boolean remainder;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "UTC")
    private Instant due;


    @JsonPOJOBuilder(withPrefix = "")
    public static class DepositPolicyBuilder {
        @JsonDeserialize(using = Deserializers.PercentStringToDecimalDeserializer.class)
        private BigDecimal percent;
    }
}
