package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Itinerary.ItineraryBuilder.class)
public class Itinerary {
    private String itineraryId;
    private String propertyId;
    private HoldItineraryLinks links;
    private String email;
    private Phone phone;
    private List<ItineraryRoom> rooms;
    private BillingContact billingContact;
    private Adjustment adjustment;
    private Instant creationDateTime;
    private String affiliateReferenceId;
    private String affiliateMetadata;
    private Conversations conversations;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ItineraryBuilder {
    }
}
