package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.commons.text.Transliterator;
import ru.yandex.travel.hotels.common.partners.expedia.ApiVersion;
import ru.yandex.travel.hotels.common.partners.expedia.Helpers;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.Address;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ItineraryReservationRequest.ItineraryReservationRequestBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ItineraryReservationRequest {
    private String affiliateReferenceId;
    private boolean hold;
    private String email;
    private Phone phone;
    @Singular
    private List<RoomRequest> rooms;
    @Singular
    private List<PaymentRequest> payments;
    private String affiliateMetadata;
    private String taxRegistrationNumber;
    private String travelerHandlingInstructions;

    public static ItineraryReservationRequest create(String affiliateId,
                                                     String firstName,
                                                     String lastName,
                                                     String email,
                                                     String phone,
                                                     String billingAddressLine,
                                                     String billingAddressCity,
                                                     String billingAddressCountry) {
        var roomBuilder = RoomRequest.builder()
                .givenName(Transliterator.transliterate(firstName))
                .familyName(Transliterator.transliterate(lastName));
        var billingContactBuilder = BillingContact.builder()
                .givenName(Transliterator.transliterate(firstName))
                .familyName(Transliterator.transliterate(lastName))
                .address(Address.builder()
                        .line1(billingAddressLine)
                        .city(billingAddressCity)
                        .countryCode(billingAddressCountry)
                        .build());

        return builder()
                .affiliateReferenceId(affiliateId)
                .hold(true)
                .email(email)
                .phone(Helpers.parsePhone(phone))
                .room(roomBuilder.build())
                .payment(PaymentRequest.builder()
                        .type(PaymentRequestType.AFFILIATE_COLLECT)
                        .billingContact(billingContactBuilder.build())
                        .build())
                .build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class ItineraryReservationRequestBuilder {
    }
}
