package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ItineraryRoom.ItineraryRoomBuilder.class)
public class ItineraryRoom {
    private String id;
    private RoomConfirmation confirmationId;
    private String bedGroupId;
    private String checkin;
    private String checkout;
    private Integer numberOfAdults;
    private List<Integer> childAges;
    private String givenName;
    private String familyName;
    private RoomStatus status;
    private String specialRequest;
    private Boolean smoking;
    private RoomRate rate;
    private RoomLinks links;


    @JsonPOJOBuilder(withPrefix = "")
    public static class ItineraryRoomBuilder {
    }
}
