package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PaymentRequest.PaymentRequestBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PaymentRequest {
    private PaymentRequestType type;
    private String number;
    private String securityCode;
    private String expirationMonth;
    private String expirationYear;
    private BillingContact billingContact;
    private LocalDate enrollmentDate;


    @JsonPOJOBuilder(withPrefix = "")
    public static class PaymentRequestBuilder {
    }
}
