package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PaymentRequestType {
    CORPORATE_CARD("corporate_card"),
    CUSTOMER_CARD("customer_card"),
    VIRTUAL_CARD("virtual_card"),
    AFFILIATE_COLLECT("affiliate_collect");

    private final String value;

    PaymentRequestType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static PaymentRequestType fromString(String value) {
        for (var candidate : PaymentRequestType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown PaymentRequestType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
