package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Phone.PhoneBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Phone
{
    private String countryCode;
    private String areaCode;
    private String number;


    @JsonPOJOBuilder(withPrefix = "")
    public static class PhoneBuilder {
    }
}
