package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.CancelPenalty;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.MerchantOfRecord;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.PricingInformation;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.Promotions;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomRate.RoomRateBuilder.class)
public class RoomRate {
    private String id;
    private MerchantOfRecord merchantOfRecord;
    private boolean refundable;
    private CancelRefund cancelRefund;
    private List<String> amenities;
    private Promotions promotions;
    private List<CancelPenalty> cancelPenalties;
    private List<DepositPolicy> depositPolicies;
    private PricingInformation pricing;


    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomRateBuilder {
    }
}
