package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomRequest.RoomRequestBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RoomRequest {
    private String givenName;
    private String familyName;
    private boolean smoking;
    private String specialRequest;



    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomRequestBuilder {
    }
}
