package ru.yandex.travel.hotels.common.partners.expedia.model.booking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum RoomStatus {
    PENDING("pending"),
    BOOKED("booked"),
    CANCELED("canceled");

    private final String value;

    RoomStatus(String value) {
        this.value = value;
    }

    @JsonCreator
    public static RoomStatus fromString(String value) {
        for (var candidate : RoomStatus.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown RoomStatus %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
